/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public class PhanteriteModifier
extends Modifier
implements InventoryTickModifierHook,
MeleeDamageModifierHook,
ProjectileHitModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.INVENTORY_TICK, ModifierHooks.MELEE_DAMAGE, ModifierHooks.PROJECTILE_HIT);
    }

    public float getMeleeDamage(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull ToolAttackContext context, float baseDamage, float damage) {
        LivingEntity target = context.getLivingTarget();
        if (target instanceof Phantom) {
            return damage * (1.0f + 0.3f * (float)modifier.getLevel());
        }
        return damage;
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        if (target instanceof Phantom && projectile instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)projectile;
            arrow.m_36781_(arrow.m_36789_() * (double)(1.0f + 0.3f * (float)modifier.getLevel()));
        }
        return false;
    }

    public void onInventoryTick(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull Level world, @Nonnull LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (!world.f_46443_ && holder.f_19797_ % 50 == 0 && holder.m_21211_() != stack && isSelected) {
            PhanteriteModifier.applyGlowing(holder, modifier.getLevel());
        }
    }

    public static <T extends Entity> void applyGlowing(LivingEntity entity, int amplifier, Class<Mob> targetClass, int minRange, float speed, int maxPush) {
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        float range = minRange + amplifier * 5;
        List targets = entity.f_19853_.m_45976_(targetClass, new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
        for (Mob target : targets) {
            if (!(target instanceof Monster)) continue;
            target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 50));
        }
    }

    public static void applyGlowing(LivingEntity entity, int amplifier) {
        PhanteriteModifier.applyGlowing(entity, amplifier, Mob.class, 10, 0.05f, 100);
    }
}

